import Tkinter
import tkFileDialog
import tkMessageBox
import sys
import os
import pickle

from TFGraphPredictor import TFGraphPredictor
from PredictConfiguration import PredictConfigurationDialog, PredictConfig


class XESTensorFlowPredictApp:

    def configure_buttons(self):
        self.lblModel.configure(text=self.modelPath[-(self.lw+10):len(self.modelPath)] if self.modelPath is not None else "")
        self.lblConfig.configure(text="{0} prediction step(s){1}".format(self.predictionConfig.numPSteps, ", EoC Detection" if self.predictionConfig.eocDetect else "") if self.predictionConfig is not None else "")
        self.lblPrepare.configure(text="{0} input(s), {1} numerical output(s), {2} categorical output(s)".format(len(self.graphPredictor.tfGraph.inputPlaceholders), len(self.graphPredictor.tfGraph.nnoutputs_concat), len(self.graphPredictor.tfGraph.softMax)) if self.graphPredictor is not None else "Ready" if self.modelPath is not None and self.predictionConfig is not None else "")

        self.btnConfig.configure(state=Tkinter.DISABLED)
        self.btnPrepare.configure(state=Tkinter.DISABLED)
        self.btnPredict.configure(state=Tkinter.DISABLED)
        if self.modelPath is not None and self.predictionConfig is not None:
            self.btnPrepare.configure(state=Tkinter.NORMAL)
            self.btnConfig.configure(state=Tkinter.NORMAL)
        if self.graphPredictor is not None:
            self.btnPredict.configure(state=Tkinter.NORMAL)

    def load_action(self):
        modelPath = tkFileDialog.askopenfilename(title="Select trained model file", filetypes=[('Model Protobuf Files', '*.ProtoBuf')])
        if len(modelPath) != 0:
            self.modelPath = modelPath

            configPath = tkFileDialog.askopenfilename(title="Select configuration file", filetypes=[('Python Pickle Files', '*.pickle')])
            if len(configPath) != 0:
                try:
                    pickleFile = open(configPath, "r")
                    self.graphConfig = pickle.load(pickleFile)
                except pickle.UnpicklingError:
                    tkMessageBox.showerror("Error", "Config pickle could not be read")
                    self.modelPath = None
                    self.graphConfig = None

            self.configure_buttons()

    def configure_action(self):
        configDlg = PredictConfigurationDialog(self.predictionConfig)
        configDlg.show()
        self.predictionConfig = PredictConfig.fromDialog(configDlg)
        if self.predictionConfig.numPSteps > 1 and not self.graphConfig.predictors == self.graphConfig.targets:
            tkMessageBox.showerror("Error", "Prediction of more than one step only possible when the set of predictors equals the set of targets")
            self.predictionConfig = PredictConfig.fromParameters(self.predictionConfig.outputPath, 1)

        self.configure_buttons()

    def prepare_action(self):
        xespath = tkFileDialog.askopenfilename(title="Select XES file", filetypes=[('XES Files', '*.xes')])
        if len(xespath) != 0:
            self.xespath = xespath
            self.graphPredictor = TFGraphPredictor(graphProtoBufPath=self.modelPath, graphConfig=self.graphConfig, xesPath=self.xespath)

            self.configure_buttons()

    def predict_action(self):
        self.graphPredictor.predict(self.predictionConfig.numPSteps, os.path.join(self.predictionConfig.outputPath, "Prediction.xes"), self.predictionConfig.eocDetect)
        self.btnPredict.flash()

        self.configure_buttons()

    @staticmethod
    def quit_action():
        print('Done')
        sys.exit(0)

    def __init__(self, root):
        p = 5
        h = 3
        w = 35
        self.lw = 50

        self.modelPath = None
        self.predictionConfig = PredictConfig()
        self.graphPredictor = None
        self.graphConfig = None
        self.xespath = None

        self.lblModel = None
        self.lblConfig = None
        self.lblPredict = None
        self.lblQuit = None

        self.btnLoad = None
        self.btnConfig = None
        self.btnPredict = None
        self.btnQuit = None

        self.tkRoot = root

        self.btnLoad = Tkinter.Button(self.tkRoot, text="Select Trained Model and Config", padx=p, pady=p, height=h, width=w)
        self.btnLoad['command'] = self.load_action
        self.btnLoad.grid(row=0, column=0, sticky="WE")
        self.lblModel = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblModel.grid(row=0, column=1, sticky="WE")

        self.btnConfig = Tkinter.Button(self.tkRoot, text="Configure Prediction", padx=p, pady=p, height=h, width=w)
        self.btnConfig['command'] = self.configure_action
        self.btnConfig.grid(row=1, column=0, sticky="WE")
        self.lblConfig = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblConfig.grid(row=1, column=1, sticky="WE")

        self.btnPrepare = Tkinter.Button(self.tkRoot, text="Load Prefix Data and Prepare Model", padx=p, pady=p, height=h, width=w)
        self.btnPrepare['command'] = self.prepare_action
        self.btnPrepare.grid(row=2, column=0, sticky="WE")
        self.lblPrepare = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblPrepare.grid(row=2, column=1, sticky="WE")

        self.btnPredict = Tkinter.Button(self.tkRoot, text="Predict from XES Model", padx=p, pady=p, height=h, width=w)
        self.btnPredict['command'] = self.predict_action
        self.btnPredict.grid(row=3, column=0, sticky="WE")
        self.lblPredict = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblPredict.grid(row=3, column=1, sticky="WE")

        self.btnQuit = Tkinter.Button(self.tkRoot, text="Quit", padx=p, pady=p, height=h, width=w)
        self.btnQuit['command'] = self.quit_action
        self.btnQuit.grid(row=4, column=0, sticky="WE")
        self.lblQuit = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblQuit.grid(row=4, column=1, sticky="WE")

        self.tkRoot.grid_columnconfigure(0, weight=1)
        self.tkRoot.grid_columnconfigure(1, weight=1)
        self.tkRoot.grid_rowconfigure(0, weight=1)
        self.tkRoot.grid_rowconfigure(1, weight=1)
        self.tkRoot.grid_rowconfigure(2, weight=1)
        self.tkRoot.grid_rowconfigure(3, weight=1)
        self.tkRoot.grid_rowconfigure(4, weight=1)

        self.configure_buttons()

    def run(self):
        while True:
            self.tkRoot.mainloop()


def on_closing():
    pass

if __name__ == "__main__":
    tkRoot = Tkinter.Tk()
    tkRoot.title("XES TensorFlow Predicter")
    tkRoot.resizable(False, False)
    tkRoot.protocol("WM_DELETE_WINDOW", on_closing)
    app = XESTensorFlowPredictApp(tkRoot)
    app.run()
