import Tkinter
import tkFileDialog
import os
import sys
import pickle

from XESConfiguration import ConfigurationDialog, TFGraphConfig
from XESParser import XESParser
from XESData import XESData
from TFGraphTrainer import TFGraphTrainer


class XESTensorFlowTrainApp:

    def configure_buttons(self):
        self.lblFile.configure(text=self.xespath[-(self.lw+10):len(self.xespath)] if self.xespath is not None and self.parser is not None else "")
        self.lblOutput.configure(text=self.logDirPath[-(self.lw+10):len(self.logDirPath)] if self.logDirPath is not None else "")
        self.lblConfig.configure(text="{0} predictor(s), {1} target(s), Optimizer: {2}".format(len(self.graphConfig.predictors), len(self.graphConfig.targets), self.graphConfig.optimizer) if self.graphConfig is not None else "")
        self.lblTrain.configure(text="Trained {0} fold(s), {1} epochs".format(self.graphTrainer.foldNum+1, self.graphTrainer.epochNum+1) if self.graphTrainer is not None else "")

        self.btnConfig.configure(state=Tkinter.DISABLED)
        self.btnTrain.configure(state=Tkinter.DISABLED)

        if self.parser is not None:
            self.btnConfig.configure(state=Tkinter.NORMAL)
        if self.graphConfig is not None:
            self.btnTrain.configure(state=Tkinter.NORMAL)

    def load_action(self):
        xespath = tkFileDialog.askopenfilename(title="Select XES file", filetypes=[('XES Files', '*.xes')])
        if len(xespath) != 0:
            self.xespath = xespath
            self.parser = XESParser(self.xespath)
            self.parser.read()
            if self.parser.getEvents() is None:
                self.parser = None

            self.graphConfig = None
            self.data = None
            self.tfGraph = None
            self.graphTrainer = None
            self.configure_buttons()

    def output_action(self):
        # Select a directory (either point to an existing one or specify a new one, which we will create in the next step
        logDirPath = tkFileDialog.askdirectory(title="Select directory for config, log, and result files", mustexist=False)
        if len(logDirPath) != 0:
            if not os.path.isdir(logDirPath):
                os.makedirs(logDirPath)
            self.logDirPath = logDirPath
            if self.graphConfig is not None:
                self.graphConfig.logDirPath = self.logDirPath

            self.configure_buttons()

    def config_action(self):
        configDlg = ConfigurationDialog(self.parser)
        configDlg.show()

        if configDlg.ok:
            self.graphConfig = TFGraphConfig(configDlg, self.logDirPath)
            self.data = XESData(self.parser.getEvents())
            self.graphConfig = self.data.finalizeData(self.graphConfig)

            # Write the configuration file
            pickleFile = open(os.path.join(self.logDirPath, os.path.basename(self.xespath) + "Config.pickle"), 'w')
            pickle.dump(self.graphConfig, pickleFile)
            pickleFile.close()

            self.tfGraph = None
            self.graphTrainer = None
            self.configure_buttons()

    def train_action(self):
        # graphBuilder = TFGraphBuilder(self.graphConfig)
        # self.tfGraph = graphBuilder.build()
        self.graphTrainer = TFGraphTrainer(tkRoot=tkRoot, graphConfig=self.graphConfig, XESData=self.data)
        self.graphTrainer.train()

        self.configure_buttons()

    @staticmethod
    def quit_action():
        print('Done')
        sys.exit(0)

    def __init__(self, root):
        p = 5
        h = 3
        w = 20
        self.lw = 50

        self.xespath = None
        self.logDirPath = os.getcwd()
        self.parser = None
        self.graphConfig = None
        self.data = None
        self.tfGraph = None
        self.graphTrainer = None

        self.lblFile = None
        self.lblOutput = None
        self.lblConfig = None
        self.lblTrain = None
        self.lblQuit = None

        self.btnLoad = None
        self.btnConfig = None
        self.btnTrain = None
        self.btnOutput = None
        self.btnQuit = None

        self.tkRoot = root

        self.btnOutput = Tkinter.Button(self.tkRoot, text="Set Output Folder", padx=p, pady=p, height=h, width=w)
        self.btnOutput['command'] = self.output_action
        self.btnOutput.grid(row=0, column=0, sticky="WE")
        self.lblOutput = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblOutput.grid(row=0, column=1, sticky="WE")

        self.btnLoad = Tkinter.Button(self.tkRoot, text="Load XES File", padx=p, pady=p, height=h, width=w)
        self.btnLoad['command'] = self.load_action
        self.btnLoad.grid(row=1, column=0, sticky="WE")
        self.lblFile = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblFile.grid(row=1, column=1, sticky="WE")

        self.btnConfig = Tkinter.Button(self.tkRoot, text="Configure Training", padx=p, pady=p, height=h, width=w)
        self.btnConfig['command'] = self.config_action
        self.btnConfig.grid(row=2, column=0, sticky="WE")
        self.lblConfig = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblConfig.grid(row=2, column=1, sticky="WE")

        self.btnTrain = Tkinter.Button(self.tkRoot, text="Train Model", padx=p, pady=p, height=h, width=w)
        self.btnTrain['command'] = self.train_action
        self.btnTrain.grid(row=3, column=0, sticky="WE")
        self.lblTrain = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblTrain.grid(row=3, column=1, sticky="WE")

        self.btnQuit = Tkinter.Button(self.tkRoot, text="Quit", padx=p, pady=p, height=h, width=w)
        self.btnQuit['command'] = self.quit_action
        self.btnQuit.grid(row=4, column=0, sticky="WE")
        self.lblQuit = Tkinter.Label(self.tkRoot, text="", padx=p, pady=p, height=h, width=self.lw, relief=Tkinter.SUNKEN, anchor=Tkinter.W, background='light grey')
        self.lblQuit.grid(row=4, column=1, sticky="WE")

        self.tkRoot.grid_columnconfigure(0, weight=1)
        self.tkRoot.grid_columnconfigure(1, weight=1)
        self.tkRoot.grid_rowconfigure(0, weight=1)
        self.tkRoot.grid_rowconfigure(1, weight=1)
        self.tkRoot.grid_rowconfigure(2, weight=1)
        self.tkRoot.grid_rowconfigure(3, weight=1)
        self.tkRoot.grid_rowconfigure(4, weight=1)

        self.configure_buttons()

    def run(self):
        while True:
            self.tkRoot.mainloop()


def on_closing():
    pass

if __name__ == "__main__":
    tkRoot = Tkinter.Tk()
    tkRoot.title("XES TensorFlow Trainer")
    tkRoot.resizable(False, False)
    tkRoot.protocol("WM_DELETE_WINDOW", on_closing)
    app = XESTensorFlowTrainApp(tkRoot)
    app.run()
