from dateutil import parser

def enum(*sequential, **named):
    enums = dict(zip(sequential, range(len(sequential))), **named)
    return type('Enum', (), enums)

XESAttributeTypes = enum('CATEGORICAL', 'NUMERIC', 'DATE')


def is_posint(s):
    try:
        int(s)
        return int(s) > 0
    except ValueError:
        return False


def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False


def is_date(s):
    try:
        parser.parse(s)
        return True
    except (ValueError, OverflowError):
        return False
