<xsl:stylesheet version="2.0" xmlns:xml="http://www.w3.org/XML/1998/namespace" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xes="http://www.xes-standard.org/">

<xsl:output method="text"/>

<xsl:template match="*|/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="text()|@*">
  <!--<xsl:value-of select="."/> -->
</xsl:template>

<xsl:template match="trace">
    <xsl:apply-templates select="event">
      <xsl:sort select="string[@key='time:timestamp']/@value"/>
    </xsl:apply-templates>
    <xsl:text>[EOC]
</xsl:text>
</xsl:template>


<xsl:template match="event">
  <xsl:if test="string[@key='lifecycle:transition' and @value='START']">
      <xsl:variable name="activityname" select="translate(string[@key='concept:name']/@value, '_-. ', '')"/>
      <xsl:variable name="start" select="date[@key='time:timestamp']/@value"/>
      <xsl:variable name="starttime" select="fn:dateTime(xs:date(substring-before($start, 'T')), xs:time(substring-after($start, 'T')))"/>
      <xsl:choose>
         <xsl:when test="count(following-sibling::event[position()=1 and string[@key='lifecycle:transition' and @value='COMPLETE'] and translate(string[@key='concept:name']/@value, '_-. ', '') =$activityname]) != 1">
           <xsl:message terminate="no">
             <xsl:text>Trace </xsl:text>
             <xsl:value-of select="../string[@key='concept:name']/@value"/>
             <xsl:text> Event </xsl:text>
             <xsl:value-of select="$activityname"/>
             <xsl:text> </xsl:text>
             <xsl:text> Wrong event sequence</xsl:text>
           </xsl:message>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="end" select="following-sibling::event[position()=1 and string[@key='lifecycle:transition' and @value='COMPLETE'] and translate(string[@key='concept:name']/@value, '_-. ', '')=$activityname]/date[@key='time:timestamp']/@value"/>
            <xsl:variable name="endtime" select="fn:dateTime(xs:date(substring-before($end, 'T')), xs:time(substring-after($end, 'T')))"/>
            <!-- Next line from http://stackoverflow.com/questions/32564736/how-can-i-convert-xsdaytimeduration-to-milliseconds-in-xpath-2-0 -->
		  <xsl:variable name="duration" select="fn:ceiling(($endtime - $starttime) div xs:dayTimeDuration('PT1M'))"/>
            <xsl:message terminate="no">
             <xsl:text>Trace </xsl:text>
             <xsl:value-of select="../string[@key='concept:name']/@value"/>
             <xsl:text> Activity </xsl:text>
             <xsl:value-of select="$activityname"/>
             <xsl:text> Duration (min) </xsl:text>
             <xsl:value-of select="$duration"/>
           </xsl:message>
           <xsl:call-template name="print">
             <xsl:with-param name="num" select="$duration"/>
             <xsl:with-param name="txt" select="$activityname"/>
           </xsl:call-template>
         </xsl:otherwise>
      </xsl:choose>  
  </xsl:if>

  <xsl:if test="string[@key='lifecycle:transition' and @value='COMPLETE']">
      <xsl:variable name="activityname" select="translate(string[@key='concept:name']/@value, '_-. ', '')"/>
      <xsl:variable name="end" select="date[@key='time:timestamp']/@value"/>
      <xsl:variable name="endtime" select="fn:dateTime(xs:date(substring-before($end, 'T')), xs:time(substring-after($end, 'T')))"/>
      <xsl:if test="count(following-sibling::event[position()=1 and string[@key='lifecycle:transition' and @value='START'] and translate(string[@key='concept:name']/@value, '_-. ', '') !=$activityname]) = 1">
         <xsl:variable name="start" select="following-sibling::event[position()=1 and string[@key='lifecycle:transition' and @value='START'] and translate(string[@key='concept:name']/@value, '_-. ', '') != $activityname]/date[@key='time:timestamp']/@value"/>
         <xsl:variable name="starttime" select="fn:dateTime(xs:date(substring-before($start, 'T')), xs:time(substring-after($start, 'T')))"/>
         <!-- Next line from http://stackoverflow.com/questions/32564736/how-can-i-convert-xsdaytimeduration-to-milliseconds-in-xpath-2-0 -->
         <xsl:variable name="duration" select="fn:ceiling(($starttime - $endtime) div xs:dayTimeDuration('PT1M'))"/>
         <xsl:message terminate="no">
           <xsl:text>Trace </xsl:text>
           <xsl:value-of select="../string[@key='concept:name']/@value"/>
           <xsl:text> GAP after </xsl:text>
           <xsl:value-of select="$activityname"/>
           <xsl:text> Duration (min) </xsl:text>
           <xsl:value-of select="$duration"/>
        </xsl:message>           
<!--        <xsl:call-template name="print">
          <xsl:with-param name="num" select="$duration"/>
          <xsl:with-param name="txt" select="GAP"/>
        </xsl:call-template>
-->      </xsl:if>
  </xsl:if>
</xsl:template>


<xsl:template name="print">
  <xsl:param name="num"/>
  <xsl:param name="txt"/>

  <xsl:if test="$num &gt; 0">
    <xsl:value-of select="$txt"/><xsl:text> </xsl:text>
    <xsl:call-template name="print">
       <xsl:with-param name="num" select="number($num)-1"/>
       <xsl:with-param name="txt" select="$txt"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>


</xsl:stylesheet>

