# Joerg Evermann, 2016
#
#!/bin/bash

function traverse() {
for file in "$1"/*.xml
do
    if [ ! -d "${file}" ] ; then
       echo "Processing ${file} file..."
       java -jar /usr/share/java/saxon.jar -s:${file} -xsl:extract.tei.xslt -o:"${file}.txt"
    fi
done
for file in "$1"/*
do
    if [ -d "${file}" ] ; then
        echo "entering recursion with: ${file}"
        traverse "${file}"
    fi
done
}

function main() {
    traverse "$1"
}

main "$1"
