d <- read.csv('unrollStepsResults.csv')
dd <- droplevels(d[d$Dataset %in% c('BPI2013.Problems','BPI2013.Incidents','BPI2012(completionevents)','BPI2013.Problems(withgroup)','BPI2013.Incidents(withgroup)','BPI2012(completionevents,resource)'),])
library(lattice)
leg.txt=c("BPI 2012 (completion events)", "BPI 2012 (completion events, resource)", "BPI 2013 Incidents", "BPI 2013 Incidents (group)", "BPI 2013 Problems", "BPI 2013 Problems (group)")
pdf('unrollStepsPlot.pdf', height=5, width=10)
p1 <- xyplot(TrainingPrecision ~ UnrollSteps, data=dd, group=Dataset, type="b", xlab="Number of unrolling steps", ylab="Training Precision", ylim=c(0.4, 0.9), auto.key=list(cex=0.75, lines=TRUE, text=leg.txt, corner=c(0,1), x=.15, y=.25, border=TRUE), scales=list(x=list(at=c(5, 10, 20))), drop.unused.levels=TRUE)
p2 <- xyplot(ValidationPrecision ~ UnrollSteps, data=dd, group=Dataset, type="b", xlab="Number of unrolling steps", ylab="Validation Precision", ylim=c(0.4, 0.9), scales=list(x=list(at=c(5, 10, 20))), drop.unused.levels=TRUE)
print(p1, split=c(1,1,2,1), more=TRUE)
print(p2, split=c(2,1,2,1), more=FALSE)
dev.off()

