d <- read.csv('precision_by_epoch.new.csv')
dd <- aggregate(d[,4:5], list(Epoch=d$Epoch, Dataset=d$Dataset), mean)
colnames(dd) <- c('Epoch', 'Dataset', 'TrainingPrecision', 'ValidationPrecision')
write.csv(dd, 'mean_precision_by_epoch.new.csv', row.names=FALSE)
library(lattice)
leg.txt <- c('BPIC 2012 A', 'BPIC 2012 O', 'BPIC 2012 W Completion Events (Resource)', 'BPIC 2013 Incidents (Group)', 'BPIC 2013 Problems')
pdf(file="precisionbyepoch.pdf", height=5, width=10)
p1 <- xyplot(TrainingPrecision ~ Epoch, group=Dataset, data=dd, main="Training Precision by Epoch", type="l", ylab="Training Precision", auto.key=list(lines=FALSE, text=leg.txt, cex=0.75, corner=c(0,1), x=.20, y=.20, border=TRUE))
p2 <- xyplot(ValidationPrecision ~ Epoch, group=Dataset, data=dd, main="Validation Precision by Epoch", type="l", ylab="Validation Precision", auto.key=FALSE)
print(p1, split=c(1,1,2,1), more=TRUE)
print(p2, split=c(2,1,2,1), more=FALSE)
dev.off()

