# Read data and model
data2 <- read.csv('dataset2.csv')
model2 <- readLines('model2.txt')

# Set up function returning the statistic
my.sem <- function(data, model) {
   # run the model with this data
   r <- sem(model, data=data)
   # return the parameter estimates
   c(r@Fit@x) 
# Do **not** naively bootstrap the fit statistic as in the following line
#   c(r@Fit@test[[1]]$stat, r@Fit@x ) 
# Needs the Bollen-Stine (1993) adapted bootstrap
}

# Generating a new sample (e.g. by ML)
my.dat.ml <- function(data, mle) {
   as.data.frame(mvrnorm(nrow(data), rep(0, nrow(cov(data))), cov(data)))
}
# Generating a new sample (e.g. by resampling)
my.dat.resample <- function(data, mle) {
   sel <- sample.int(nrow(data), nrow(data), replace=TRUE)
   data[sel, ]
}

# Performing the bootstrap function
boot.res <- boot(data2, my.sem, 100, sim="parametric", ran.gen=my.dat.resample, mle=NULL, model=model2)
# Printing the results
boot.res
# Plotting the results
plot(boot.res, 2)

