# Read data and model
data2 <- read.csv('dataset2.csv')
model2 <- readLines('model2.txt')

# Set up function returning the statistic
my.sem <- function(data, model) {
   # run the model with this data
   r <- sem(model, data=data)
   # Return the fit test statistic
   c(r@Fit@test[[1]]$stat) 
}

# Generating a new sample (e.g. by ML)
my.dat.ml <- function(data, mle) {
   as.data.frame(mvrnorm(nrow(data), rep(0, nrow(cov(data))), cov(data)))
}
# Generating a new sample (e.g. by resampling)
my.dat.resample <- function(data, mle) {
   sel <- sample.int(nrow(data), nrow(data), replace=TRUE)
   data[sel, ]
}


# Modify the data sample as per Bollen & Stine (1993)
modified.data <- function(data, model) {
   # run the model for the estimated covariance matrix
   ctr.data <- data - mean(data)
   r <- sem(model, data=ctr.data)
   # return adjusted data
   mod.data <- data.frame(as.matrix(ctr.data) %*% solve(chol(cov(ctr.data))) %*% chol(r@Fit@Sigma.hat[[1]]))
   names(mod.data) <- names(data)
   mod.data
}

mod.data <- modified.data(data2, model2)
# Performing the bootstrap function
boot.res <- boot(mod.data, my.sem, 100, sim="parametric", ran.gen=my.dat.resample, mle=NULL, model=model2)
# Printing the results
boot.res
# Plotting the results
plot(boot.res)

