library(MCMCpack)

constraints <- list(
  eou1=list(1, 1),
  eou1=list(2, 0),
  eou1=list(3, 0),
  eou2=list(2, 0),
  eou2=list(3, 0),
  eou3=list(2, 0),
  eou3=list(3, 0),
  use1=list(2, 1),
  use1=list(1, 0),
  use1=list(3, 0),
  use2=list(1, 0),
  use2=list(3, 0),
  use3=list(1, 0),
  use3=list(3, 0),
  int1=list(3, 1),
  int1=list(1, 0),
  int1=list(2, 0),
  int2=list(1, 0),
  int2=list(2, 0),
  int3=list(1, 0),
  int3=list(2, 0))

res <- NULL
for (i in seq(100,500,by=50)) {
  print(i)
  f <- MCMCfactanal(as.matrix(data24)[1:i,], factors=3, lambda.constraints=constraints, l0=0.5, L0=10, a0=6, b0=10)
  res <- rbind(res, c(i, summary(f)$statistics[,1]) )
}
plot(res[,2]~res[,1], type='b', xlab="Sample Size", ylab="Estimate")

res <- NULL
for (l0 in seq(0,1,by=0.1)) {
  print(l0)
  f <- MCMCfactanal(as.matrix(data24), factors=3, lambda.constraints=constraints, l0=l0, L0=10, a0=6, b0=10)
  res <- rbind(res, c(l0, summary(f)$statistics[,1]) )
}
plot(res[,2]~res[,1], type='b', xlab="l0", ylab="Estimate")

res <- NULL
for (L0 in seq(0,10,by=1)) {
  print(L0)
  f <- MCMCfactanal(as.matrix(data24), factors=3, lambda.constraints=constraints, l0=0.5, L0=L0, a0=6, b0=10)
  res <- rbind(res, c(L0, summary(f)$statistics[,1]) )
}
plot(res[,2]~res[,1], type='b', xlab="L0", ylab="Estimate")

res <- NULL
for (L0 in seq(0,10,by=1)) {
  print(L0)
  f <- MCMCfactanal(as.matrix(data24), factors=3, lambda.constraints=constraints, l0=0.5, L0=L0, a0=6, b0=10)
  res <- rbind(res, c(L0, summary(f)$statistics[,1]) )
}
plot(res[,2]~res[,1], type='b', xlab="L0", ylab="Estimate")

res <- NULL
for (a0 in seq(2,10,by=2)) {
  print(a0)
  f <- MCMCfactanal(as.matrix(data24), factors=3, lambda.constraints=constraints, l0=0.5, L0=10, a0=a0, b0=a0*2)
  res <- rbind(res, c(a0, a0*2, summary(f)$statistics[,1]) )
}
plot(res[,9]~res[,1], type='b', xlab="a0", ylab="Estimate")
