#*****************************************
# These functions are taken form the
# dprep package for R, after it was
# deprecated and removed from CRAN
#*****************************************
#
# Package: dprep
# Type: Package
# Title: Data preprocessing and visualization functions for
#         classification
# Version: 2.1
# Date: 2009-08-21
# Author: Edgar Acuna<edgar@cs.uprm.edu>, and members of the CASTLE group
#         at UPR-Mayaguez, Puerto Rico.
#
#******************************************

mo4 <-
function(data) 
{
#*****************************************
# This function computes the third momnent.
# It is required by the mardia function
# Edgar Acuna (2005)
#********************************************
nrows=dim(data)[1]
xbar=colMeans(data)
sigma=cov(data)
mo4=mean(mahalanobis(data,center=xbar,cov=sigma)^2)
return(mo4)
}

mo3 <-
function(data) 
{#*********************************************
# This function computes the third moment.
# It is required by the mardia function
# Edgar Acuna (2005)
#************************************************
data=as.matrix(data)
p=dim(data)[2]
nrows=dim(data)[1]
#print(nrows)
m3=matrix(0,nrows,nrows)
#print(m3)
xbar=colMeans(data)
sigma=cov(data)
for(i in 1:nrows)
{for(j in 1:nrows)
{m3[i,j]=(t(data[i,]-xbar))%*%solve(sigma)%*%(data[j,]-xbar)
}
}
m3=m3^3
mo3=sum(apply(m3,1,sum))/(nrows*nrows)
#print(mo3)
}

mardia <-
function (data) 
{#************************************
# Mardia test for multivariate normality
# Needs function mo3 and mo4
# Edgar Acuna
#******************************
p=dim(data)[2]
f=p-1
clases=length(table(data[,p]))
for(i in 1:clases)
{
data1=data[data[,p]==i,-p]
ndat=dim(data1)[1]
mo3=mo3(data1)
mard1=ndat*mo3/6
cat("Mardia's test for class",i,"\n")
cat("mard1=",mard1,"\n")
p1=1-pchisq(mard1,df=f*(f+1)*(f+2)/6)
cat("pvalue for m3=",p1,"\n")
mo4=mo4(data1)
mard2=(mo4-f*(f+2))/sqrt(8*f*(f+2)/ndat)
cat("mard2=",mard2,"\n")
p2=2*(1-pnorm(abs(mard2)))
cat("p-value for m4=",p2,"\n")
if(p1<.05|| p2<.05)
cat("There is not statistical evidence for normality in class",i,"\n")
else
cat("There is statistical evidence for normality","\n")
}
}

