require('matrixcalc')

GFI.group <- function(x, g) {

  Sig.hat <- x@Fit@Sigma.hat[[g]]
  S <- x@Sample@cov[[g]]
  Sig.hat.inv <- solve(Sig.hat)

  GFI.group <- 1 -  matrix.trace(
     (Sig.hat.inv %*% (S - Sig.hat)) %*%
    t(Sig.hat.inv %*% (S - Sig.hat)) ) / 
              matrix.trace(
     (Sig.hat.inv %*% S) %*%
    t(Sig.hat.inv %*% S) )
  GFI.group
}

sem.GFI <- function(x) {
  G <- x@Sample@ngroups
  N <- x@Sample@ntotal

  GFI <- 0
  for (g in 1:G) { 
    GFI <- GFI + GFI.group(x, g) * x@Sample@nobs[[g]]/N
  }
  GFI
}

